/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Point;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.function.IntConsumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.runelite.api.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupUtils {
    private static final Logger log = LoggerFactory.getLogger(PopupUtils.class);

    public static void displayPopupMessage(Client client, String title, String message, String[] buttonLabels, IntConsumer buttonIndexConsumer) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame(title);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 8, 8));
            String html = String.format("<html><style>a { color: #dc8a00; }</style><body>%s</body></html>", message);
            JEditorPane messagePane = new JEditorPane("text/html", html);
            messagePane.setBorder(BorderFactory.createEmptyBorder());
            messagePane.setHighlighter(null);
            messagePane.setEditable(false);
            messagePane.setOpaque(false);
            messagePane.addHyperlinkListener(e -> {
                if (Desktop.isDesktopSupported() && e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException ex) {
                        log.error("Unable to open link: {}", (Object)e.getURL().toString(), (Object)ex);
                    }
                }
            });
            JScrollPane scrollPane = new JScrollPane(messagePane);
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(31);
            mainPanel.add((Component)scrollPane, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 8, 8));
            int i = 0;
            while (i < buttonLabels.length) {
                JButton button = new JButton(buttonLabels[i]);
                int index = i++;
                button.addActionListener(actionEvent -> {
                    frame.setVisible(false);
                    buttonIndexConsumer.accept(index);
                });
                buttonPanel.add(button);
            }
            JPanel framePanel = new JPanel(new BorderLayout());
            framePanel.add((Component)mainPanel, "Center");
            framePanel.add((Component)buttonPanel, "Last");
            frame.setContentPane(framePanel);
            frame.pack();
            frame.setResizable(false);
            frame.setLocationRelativeTo(client.getCanvas());
            Point point = frame.getLocation();
            frame.setLocation(point.x + 5, point.y + (503 - client.getCanvasHeight()) / 2 - 3);
            frame.setAutoRequestFocus(true);
            JFrame runeLiteWindow = (JFrame)SwingUtilities.getWindowAncestor(client.getCanvas());
            if (runeLiteWindow.isAlwaysOnTop()) {
                frame.setAlwaysOnTop(true);
            }
            frame.setVisible(true);
        });
    }
}

