/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.keyremapping;

import com.google.inject.Inject;
import com.google.inject.Provides;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.keyremapping.KeyRemappingConfig;
import net.runelite.client.plugins.keyremapping.KeyRemappingListener;

@PluginDescriptor(name="Key Remapping", description="Allows use of WASD keys for camera movement with 'Press Enter to Chat', and remapping number keys to F-keys", tags={"enter", "chat", "wasd", "camera"}, enabledByDefault=false)
public class KeyRemappingPlugin
extends Plugin {
    private final int[] clickHereToContinueButtons = new int[]{368, 363, 359, 356, 4882, 4887, 4893, 4900, 968, 973, 979, 986, 4267, 6237, 4261, 4277, 6263, 6231, 6226, 6258, 4282, 4272, 6221, 4416, 12122, 13929};
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    @Inject
    private KeyRemappingListener inputListener;
    private boolean typing;

    private boolean isClickHereToContinueButton(int buttonId) {
        for (int clickHereToContinueButton : this.clickHereToContinueButtons) {
            if (clickHereToContinueButton != buttonId) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void startUp() throws Exception {
        this.typing = false;
        this.keyManager.registerKeyListener(this.inputListener);
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.lockChat();
            }
        });
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.unlockChat();
            }
        });
        this.keyManager.unregisterKeyListener(this.inputListener);
    }

    @Provides
    KeyRemappingConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(KeyRemappingConfig.class);
    }

    boolean chatboxFocused() {
        return true;
    }

    boolean isDialogOpen() {
        return this.client.getDialogState() != 0;
    }

    boolean isOptionsDialogOpen() {
        return this.isClickHereToContinueButton(this.client.getDialogState());
    }

    void lockChat() {
        this.client.setChatLocked(true);
    }

    void unlockChat() {
        this.client.setChatLocked(false);
    }

    boolean isTyping() {
        return this.typing;
    }

    void setTyping(boolean typing) {
        this.typing = typing;
    }
}

