/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.lifesaver;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.lifesaver.LifeSaverConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Life Saver", description="Forces a notification when at or below specified hitpoints", tags={"health", "hitpoints", "notifications"}, enabledByDefault=false)
public class LifeSaverPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LifeSaverPlugin.class);
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private LifeSaverConfig config;
    private boolean notifyHitpoints = true;

    @Provides
    LifeSaverConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(LifeSaverConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        if (this.client.getGameState() != GameState.LOGGED_IN || local == null) {
            return;
        }
        if (this.checkLowHitpoints()) {
            this.notifier.notify("You have low hitpoints!");
        }
    }

    private boolean checkLowHitpoints() {
        if (this.config.getHitpointsThreshold() == 0) {
            return false;
        }
        if (this.client.getRealSkillLevel(Skill.HITPOINTS) > this.config.getHitpointsThreshold()) {
            if (this.client.getBoostedSkillLevel(Skill.HITPOINTS) <= this.config.getHitpointsThreshold()) {
                if (!this.notifyHitpoints) {
                    this.notifyHitpoints = true;
                    return true;
                }
            } else {
                this.notifyHitpoints = false;
            }
        }
        return false;
    }
}

