/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.visualmetronome;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.plugins.visualmetronome.visualmetronomeConfig;
import net.runelite.client.plugins.visualmetronome.visualmetronomePlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;

public class FullResizableVisualMetronomeOverlay
extends Overlay {
    private final visualmetronomeConfig config;
    private final visualmetronomePlugin plugin;
    private static int TITLE_PADDING = 10;
    private static final int MINIMUM_SIZE = 16;

    @Inject
    public FullResizableVisualMetronomeOverlay(visualmetronomeConfig config, visualmetronomePlugin plugin) {
        super(plugin);
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setMinimumSize(16);
        this.setResizable(true);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Dimension preferredSize = this.getPreferredSize();
        if (preferredSize == null) {
            preferredSize = this.plugin.DEFAULT_SIZE;
            this.setPreferredSize(preferredSize);
        }
        if (this.config.enableMetronome()) {
            graphics.setColor(this.plugin.CurrentColor);
            graphics.fillRect(0, 0, preferredSize.width, preferredSize.height);
            TITLE_PADDING = Math.min(preferredSize.width, preferredSize.height) / 2 - 4;
            if (this.config.showTick()) {
                graphics.setColor(this.config.NumberColor());
                graphics.drawString(String.valueOf(this.plugin.tickCounter), TITLE_PADDING, preferredSize.height - TITLE_PADDING);
            }
        }
        return preferredSize;
    }
}

