/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.visualmetronome;

import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Dimension;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.visualmetronome.FullResizableVisualMetronomeOverlay;
import net.runelite.client.plugins.visualmetronome.visualmetronomeConfig;
import net.runelite.client.plugins.visualmetronome.visualmetronomeTileOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Visual Metronome", description="Shows a visual cue on an overlay every game tick to help timing based activities", tags={"timers", "overlays", "tick", "skilling"}, enabledByDefault=false)
public class visualmetronomePlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private visualmetronomeTileOverlay tileOverlay;
    @Inject
    private FullResizableVisualMetronomeOverlay overlay;
    @Inject
    private visualmetronomeConfig config;
    private boolean CurrentTick = true;
    public int tickCounter = 0;
    public Color CurrentColor = Color.WHITE;
    public Dimension DEFAULT_SIZE = new Dimension(25, 25);

    @Provides
    visualmetronomeConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(visualmetronomeConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.config.tickCount() != 1) {
            if (this.tickCounter % this.config.tickCount() == 0) {
                this.tickCounter = 0;
                this.CurrentTick = !this.CurrentTick;
                this.CurrentColor = this.CurrentTick ? this.config.getTickColor() : this.config.getTockColor();
            }
            ++this.tickCounter;
            return;
        }
        if (this.tickCounter == this.config.colorCycle()) {
            this.tickCounter = 0;
        }
        switch (++this.tickCounter) {
            case 1: {
                this.CurrentColor = this.config.getTickColor();
                break;
            }
            case 2: {
                this.CurrentColor = this.config.getTockColor();
                break;
            }
            case 3: {
                this.CurrentColor = this.config.getTick3Color();
                break;
            }
            case 4: {
                this.CurrentColor = this.config.getTick4Color();
                break;
            }
            case 5: {
                this.CurrentColor = this.config.getTick5Color();
                break;
            }
            case 6: {
                this.CurrentColor = this.config.getTick6Color();
                break;
            }
            case 7: {
                this.CurrentColor = this.config.getTick7Color();
                break;
            }
            case 8: {
                this.CurrentColor = this.config.getTick8Color();
                break;
            }
            case 9: {
                this.CurrentColor = this.config.getTick9Color();
                break;
            }
            case 10: {
                this.CurrentColor = this.config.getTick10Color();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.tickCounter > this.config.colorCycle()) {
            this.tickCounter = 0;
        }
        this.DEFAULT_SIZE = new Dimension(this.config.boxWidth(), this.config.boxWidth());
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        this.overlay.setPreferredSize(this.DEFAULT_SIZE);
        this.overlayManager.add(this.tileOverlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
        this.overlayManager.remove(this.tileOverlay);
        this.tickCounter = 0;
    }
}

