/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.visualmetronome;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.visualmetronome.visualmetronomeConfig;
import net.runelite.client.plugins.visualmetronome.visualmetronomePlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class visualmetronomeTileOverlay
extends Overlay {
    private final Client client;
    private final visualmetronomeConfig config;
    private final visualmetronomePlugin plugin;

    @Inject
    public visualmetronomeTileOverlay(Client client, visualmetronomeConfig config, visualmetronomePlugin plugin) {
        super(plugin);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.highlightCurrentTile()) {
            WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
            if (playerPos == null) {
                return null;
            }
            LocalPoint playerPosLocal = LocalPoint.fromWorld(this.client, playerPos);
            if (playerPosLocal == null) {
                return null;
            }
            this.renderTile(graphics, playerPosLocal, this.plugin.CurrentColor, this.config.currentTileFillColor(), this.config.currentTileBorderWidth());
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, Color fillColor, double borderWidth) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, dest);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon(graphics, poly, color, fillColor, new BasicStroke((float)borderWidth));
    }
}

