/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSException;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.Krb5TokenUtils;
import org.jgroups.util.Util;

@Experimental
public class Krb5Token
extends AuthToken {
    private static final String JASS_SECURITY_CONFIG = "JGoupsKrb5TokenSecurityConf";
    public static final String CLIENT_PRINCIPAL_NAME = "client_principal_name";
    public static final String CLIENT_PASSWORD = "client_password";
    public static final String SERVICE_PRINCIPAL_NAME = "service_principal_name";
    @Property
    protected String client_principal_name;
    @Property(exposeAsManagedAttribute=false)
    protected String client_password;
    @Property
    protected String service_principal_name;
    private Subject subject;
    private byte[] krbServiceTicket;
    private byte[] remoteKrbServiceTicket;

    public void setValue(Properties properties2) {
        String value = properties2.getProperty(CLIENT_PRINCIPAL_NAME);
        if (value != null) {
            this.client_principal_name = value;
            properties2.remove(CLIENT_PRINCIPAL_NAME);
        }
        if ((value = properties2.getProperty(CLIENT_PASSWORD)) != null) {
            this.client_password = value;
            properties2.remove(CLIENT_PASSWORD);
        }
        if ((value = properties2.getProperty(SERVICE_PRINCIPAL_NAME)) != null) {
            this.service_principal_name = value;
            properties2.remove(SERVICE_PRINCIPAL_NAME);
        }
        try {
            this.authenticateClientPrincipal();
        }
        catch (Exception e) {
            this.log.warn("Krb5Token failed to authenticate", e);
            this.subject = null;
        }
    }

    @Override
    public String getName() {
        return Krb5Token.class.getName();
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        if (!this.isAuthenticated()) {
            this.log.error(Util.getMessage("Krb5TokenFailedToSetupCorrectlyCannotAuthenticateAnyPeers"));
            return false;
        }
        if (token instanceof Krb5Token) {
            Krb5Token remoteToken = (Krb5Token)token;
            try {
                this.validateRemoteServiceTicket(remoteToken);
                return true;
            }
            catch (Exception e) {
                this.log.error(Util.getMessage("Krb5TokenServiceTicketValidationFailed"), e);
                return false;
            }
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.isAuthenticated()) {
            this.generateServiceTicket();
            this.writeServiceTicketToSream(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.readRemoteServiceTicketFromStream(in);
    }

    @Override
    public int size() {
        return Util.size(this.krbServiceTicket);
    }

    private boolean isAuthenticated() {
        return this.subject != null;
    }

    private void authenticateClientPrincipal() throws LoginException {
        this.subject = Krb5TokenUtils.generateSecuritySubject(JASS_SECURITY_CONFIG, this.client_principal_name, this.client_password);
    }

    private void generateServiceTicket() throws IOException {
        try {
            this.krbServiceTicket = Krb5TokenUtils.initiateSecurityContext(this.subject, this.service_principal_name);
        }
        catch (GSSException ge) {
            throw new IOException("Failed to generate serviceticket", ge);
        }
    }

    private void validateRemoteServiceTicket(Krb5Token remoteToken) throws Exception {
        byte[] remoteKrbServiceTicketLocal = remoteToken.remoteKrbServiceTicket;
        String clientPrincipalName = Krb5TokenUtils.validateSecurityContext(this.subject, remoteKrbServiceTicketLocal);
        if (!clientPrincipalName.equals(this.client_principal_name)) {
            throw new Exception("Client Principal Names did not match");
        }
    }

    private void writeServiceTicketToSream(DataOutput out) throws IOException {
        try {
            Krb5TokenUtils.encodeDataToStream(this.krbServiceTicket, out);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void readRemoteServiceTicketFromStream(DataInput in) throws IOException {
        try {
            this.remoteKrbServiceTicket = Krb5TokenUtils.decodeDataFromStream(in);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

