/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.ReplicatedMap;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class ReplicatedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Receiver,
ReplicatedMap<K, V>,
Closeable {
    private static final short PUT = 1;
    private static final short PUT_IF_ABSENT = 2;
    private static final short PUT_ALL = 3;
    private static final short REMOVE = 4;
    private static final short REMOVE_IF_EQUALS = 5;
    private static final short REPLACE_IF_EXISTS = 6;
    private static final short REPLACE_IF_EQUALS = 7;
    private static final short CLEAR = 8;
    protected static Map<Short, Method> methods;
    private final JChannel channel;
    protected RpcDispatcher disp = null;
    private String cluster_name = null;
    private final Set<Notification> notifs = new CopyOnWriteArraySet<Notification>();
    private final List<Address> members = new ArrayList<Address>();
    protected final RequestOptions call_options = new RequestOptions(ResponseMode.GET_NONE, 5000L);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected ConcurrentMap<K, V> map = null;

    public ReplicatedHashMap(JChannel channel) {
        this.channel = channel;
        this.map = new ConcurrentHashMap();
        this.init();
    }

    public ReplicatedHashMap(ConcurrentMap<K, V> map, JChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Cannot create ReplicatedHashMap with null channel");
        }
        if (map == null) {
            throw new IllegalArgumentException("Cannot create ReplicatedHashMap with null map");
        }
        this.map = map;
        this.cluster_name = channel.getClusterName();
        this.channel = channel;
        this.init();
    }

    protected final void init() {
        this.disp = new RpcDispatcher(this.channel, this).setMethodLookup(id -> methods.get(id));
        this.disp.setReceiver(this);
    }

    public boolean isBlockingUpdates() {
        return this.call_options.mode() == ResponseMode.GET_ALL;
    }

    public void setBlockingUpdates(boolean blocking_updates) {
        this.call_options.mode(blocking_updates ? ResponseMode.GET_ALL : ResponseMode.GET_NONE);
    }

    public long getTimeout() {
        return this.call_options.timeout();
    }

    public void setTimeout(long timeout2) {
        this.call_options.timeout(timeout2);
    }

    public final void start(long state_timeout) throws Exception {
        this.channel.getState(null, state_timeout);
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (n != null) {
            this.notifs.add(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (n != null) {
            this.notifs.remove(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public V put(K key, V value) {
        V prev_val = this.get(key);
        try {
            MethodCall call = new MethodCall(1, key, value);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("put(" + key + ", " + value + ") failed", e);
        }
        return prev_val;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V prev_val = this.get(key);
        try {
            MethodCall call = new MethodCall(2, key, value);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("putIfAbsent(" + key + ", " + value + ") failed", e);
        }
        return prev_val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m3) {
        try {
            MethodCall call = new MethodCall(3, m3);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Throwable t) {
            throw new RuntimeException("putAll() failed", t);
        }
    }

    @Override
    public void clear() {
        try {
            MethodCall call = new MethodCall(8, new Object[0]);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("clear() failed", e);
        }
    }

    @Override
    public V remove(Object key) {
        V retval = this.get(key);
        try {
            MethodCall call = new MethodCall(4, key);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("remove(" + key + ") failed", e);
        }
        return retval;
    }

    @Override
    public boolean remove(Object key, Object value) {
        V val = this.get(key);
        boolean removed = Objects.equals(val, value);
        try {
            MethodCall call = new MethodCall(5, key, value);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("remove(" + key + ", " + value + ") failed", e);
        }
        return removed;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        V val = this.get(key);
        boolean replaced = Objects.equals(val, oldValue);
        try {
            MethodCall call = new MethodCall(7, key, oldValue, newValue);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("replace(" + key + ", " + oldValue + ", " + newValue + ") failed", e);
        }
        return replaced;
    }

    @Override
    public V replace(K key, V value) {
        V retval = this.get(key);
        try {
            MethodCall call = new MethodCall(6, key, value);
            this.disp.callRemoteMethods(null, call, this.call_options);
        }
        catch (Exception e) {
            throw new RuntimeException("replace(" + key + ", " + value + ") failed", e);
        }
        return retval;
    }

    @Override
    public V _put(K key, V value) {
        V retval = this.map.put(key, value);
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return retval;
    }

    @Override
    public V _putIfAbsent(K key, V value) {
        V retval = this.map.putIfAbsent(key, value);
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return retval;
    }

    @Override
    public void _putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
        if (!map.isEmpty()) {
            for (Notification notif : this.notifs) {
                notif.contentsSet(map);
            }
        }
    }

    @Override
    public void _clear() {
        this.map.clear();
        this.notifs.forEach(Notification::contentsCleared);
    }

    @Override
    public V _remove(K key) {
        Object retval = this.map.remove(key);
        if (retval != null) {
            for (Notification notif : this.notifs) {
                notif.entryRemoved(key);
            }
        }
        return retval;
    }

    @Override
    public boolean _remove(K key, V value) {
        boolean removed = this.map.remove(key, value);
        if (removed) {
            for (Notification notif : this.notifs) {
                notif.entryRemoved(key);
            }
        }
        return removed;
    }

    @Override
    public boolean _replace(K key, V oldValue, V newValue) {
        boolean replaced = this.map.replace(key, oldValue, newValue);
        if (replaced) {
            for (Notification notif : this.notifs) {
                notif.entrySet(key, newValue);
            }
        }
        return replaced;
    }

    @Override
    public V _replace(K key, V value) {
        V retval = this.map.replace(key, value);
        for (Notification notif : this.notifs) {
            notif.entrySet(key, value);
        }
        return retval;
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        HashMap<K, V> copy2 = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            copy2.put(key, val);
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(ostream, 1024));){
            oos.writeObject(copy2);
        }
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        HashMap new_copy = null;
        try (ObjectInputStream ois = new ObjectInputStream(istream);){
            new_copy = (HashMap)ois.readObject();
        }
        if (new_copy != null) {
            this._putAll(new_copy);
        }
        this.log.debug("state received successfully");
    }

    @Override
    public void viewAccepted(View new_view) {
        List<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_view, new_mbrs, new ArrayList<Address>(this.members));
            this.members.clear();
            this.members.addAll(new_mbrs);
        }
    }

    void sendViewChangeNotifications(View view, List<Address> new_mbrs, List<Address> old_mbrs) {
        if (this.notifs.isEmpty() || old_mbrs == null || new_mbrs == null) {
            return;
        }
        List joined = new_mbrs.stream().filter(mbr -> !old_mbrs.contains(mbr)).collect(Collectors.toList());
        List left = old_mbrs.stream().filter(mbr -> !new_mbrs.contains(mbr)).collect(Collectors.toList());
        this.notifs.forEach((? super T notif) -> notif.viewChange(view, joined, left));
    }

    public static <K, V> ReplicatedMap<K, V> synchronizedMap(ReplicatedMap<K, V> map) {
        return new SynchronizedReplicatedMap<K, V>(map);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                ReplicatedHashMap.this.clear();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = ReplicatedHashMap.this.map.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> cur = null;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.cur = (Map.Entry)it.next();
                        return this.cur;
                    }

                    @Override
                    public void remove() {
                        if (this.cur == null) {
                            throw new IllegalStateException();
                        }
                        ReplicatedHashMap.this.remove(this.cur.getKey());
                        this.cur = null;
                    }
                };
            }

            @Override
            public int size() {
                return ReplicatedHashMap.this.map.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    static {
        try {
            methods = new HashMap<Short, Method>(8);
            methods.put((short)1, ReplicatedHashMap.class.getMethod("_put", Object.class, Object.class));
            methods.put((short)2, ReplicatedHashMap.class.getMethod("_putIfAbsent", Object.class, Object.class));
            methods.put((short)3, ReplicatedHashMap.class.getMethod("_putAll", Map.class));
            methods.put((short)4, ReplicatedHashMap.class.getMethod("_remove", Object.class));
            methods.put((short)5, ReplicatedHashMap.class.getMethod("_remove", Object.class, Object.class));
            methods.put((short)6, ReplicatedHashMap.class.getMethod("_replace", Object.class, Object.class));
            methods.put((short)7, ReplicatedHashMap.class.getMethod("_replace", Object.class, Object.class, Object.class));
            methods.put((short)8, ReplicatedHashMap.class.getMethod("_clear", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class SynchronizedReplicatedMap<K, V>
    implements ReplicatedMap<K, V> {
        private final ReplicatedMap<K, V> map;
        private final Object mutex;
        private Set<K> keySet = null;
        private Set<Map.Entry<K, V>> entrySet = null;
        private Collection<V> values = null;

        private SynchronizedReplicatedMap(ReplicatedMap<K, V> map) {
            this.map = map;
            this.mutex = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m3) {
            Object object = this.mutex;
            synchronized (object) {
                this.map.putAll(m3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Collections.synchronizedSet(this.map.keySet());
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Collections.synchronizedCollection(this.map.values());
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Collections.synchronizedSet(this.map.entrySet());
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.map._putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.map._clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _remove(K key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _remove(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V _replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map._replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.map.equals(obj2);
            }
        }
    }

    public static interface Notification<K, V> {
        public void entrySet(K var1, V var2);

        public void entryRemoved(K var1);

        public void viewChange(View var1, List<Address> var2, List<Address> var3);

        public void contentsSet(Map<K, V> var1);

        public void contentsCleared();
    }
}

