/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

public class ConfiguratorFactory {
    public static final String JAXP_MISSING_ERROR_MSG = "the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.";

    protected ConfiguratorFactory() {
    }

    public static ProtocolStackConfigurator getStackConfigurator(File file) throws Exception {
        ConfiguratorFactory.checkJAXPAvailability();
        InputStream input = ConfiguratorFactory.getConfigStream(file);
        return XmlConfigurator.getInstance(input);
    }

    public static ProtocolStackConfigurator getStackConfigurator(InputStream input) throws Exception {
        return XmlConfigurator.getInstance(input);
    }

    public static ProtocolStackConfigurator getStackConfigurator(String properties2) throws Exception {
        XmlConfigurator configurator;
        if (properties2 == null) {
            properties2 = "udp.xml";
        }
        if ((configurator = ConfiguratorFactory.getXmlConfigurator(Objects.requireNonNull(properties2))) != null) {
            return configurator;
        }
        throw new IllegalStateException(String.format("configuration %s not found or invalid", properties2));
    }

    public static InputStream getConfigStream(File file) throws Exception {
        return new FileInputStream(Objects.requireNonNull(file));
    }

    public static InputStream getConfigStream(String properties2) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new FileInputStream(properties2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (configStream == null) {
            try {
                configStream = new URL(properties2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (configStream == null && properties2.endsWith("xml")) {
            configStream = Util.getResourceAsStream(properties2, ConfiguratorFactory.class);
        }
        return configStream;
    }

    public static InputStream getConfigStream(Object properties2) throws IOException {
        InputStream input = null;
        if (properties2 == null) {
            properties2 = "udp.xml";
        }
        if (properties2 instanceof URL) {
            try {
                input = ((URL)properties2).openStream();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input == null && properties2 instanceof String) {
            input = ConfiguratorFactory.getConfigStream((String)properties2);
        }
        if (input == null && properties2 instanceof File) {
            try {
                input = new FileInputStream((File)properties2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return input;
        }
        if (properties2 instanceof Element) {
            return ConfiguratorFactory.getConfigStream(properties2);
        }
        return new ByteArrayInputStream(((String)properties2).getBytes());
    }

    static XmlConfigurator getXmlConfigurator(String properties2) throws IOException {
        XmlConfigurator returnValue = null;
        InputStream configStream = ConfiguratorFactory.getConfigStream(properties2);
        if (configStream == null && properties2.endsWith("xml")) {
            throw new FileNotFoundException(String.format(Util.getMessage("FileNotFound"), properties2));
        }
        if (configStream != null) {
            ConfiguratorFactory.checkJAXPAvailability();
            returnValue = XmlConfigurator.getInstance(configStream);
        }
        return returnValue;
    }

    static void checkJAXPAvailability() {
        try {
            XmlConfigurator.class.getName();
        }
        catch (NoClassDefFoundError error) {
            NoClassDefFoundError tmp = new NoClassDefFoundError(JAXP_MISSING_ERROR_MSG);
            tmp.initCause(error);
            throw tmp;
        }
    }
}

