/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.nio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jgroups.util.Util;

public class Buffers
implements Iterable<ByteBuffer> {
    protected final ByteBuffer[] bufs;
    protected short position;
    protected short limit;
    protected short next_to_copy;
    protected int max_length;

    public Buffers(int capacity) {
        this.bufs = new ByteBuffer[Buffers.toPositiveUnsignedShort(capacity)];
    }

    public Buffers(ByteBuffer ... data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("null buffer array");
        }
        Buffers.assertPositiveUnsignedShort(data2.length);
        for (ByteBuffer b : this.bufs = data2) {
            if (b == null) break;
            this.limit = (short)(this.limit + 1);
        }
    }

    public int position() {
        return this.position;
    }

    public Buffers position(int new_pos) {
        this.position = Buffers.toPositiveUnsignedShort(new_pos);
        this.nextToCopy(new_pos);
        return this;
    }

    public int limit() {
        return this.limit;
    }

    public Buffers limit(int new_limit) {
        this.limit = Buffers.toPositiveUnsignedShort(new_limit);
        return this;
    }

    public int nextToCopy() {
        return this.next_to_copy;
    }

    public Buffers nextToCopy(int next2) {
        this.next_to_copy = Buffers.toPositiveUnsignedShort(next2);
        return this;
    }

    public int maxLength() {
        return this.max_length;
    }

    public Buffers maxLength(int len) {
        this.max_length = len;
        return this;
    }

    public int remaining() {
        int remaining = 0;
        for (int i = this.position; i < this.limit; ++i) {
            ByteBuffer buf = this.bufs[i];
            if (buf == null) continue;
            remaining += buf.remaining();
        }
        return remaining;
    }

    public boolean hasRemaining() {
        for (int i = this.position; i < this.limit; ++i) {
            ByteBuffer buf = this.bufs[i];
            if (buf == null || !buf.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public Buffers add(ByteBuffer ... buffers) {
        if (buffers == null) {
            return this;
        }
        Buffers.assertPositiveUnsignedShort(buffers.length);
        int len = buffers.length;
        if (this.spaceAvailable(len) || this.makeSpace() && this.spaceAvailable(len)) {
            for (ByteBuffer buf : buffers) {
                short s2 = this.limit;
                this.limit = (short)(s2 + 1);
                this.bufs[s2] = buf;
            }
        }
        return this;
    }

    public Buffers add(ByteBuffer buf) {
        if (buf == null) {
            return this;
        }
        if (this.spaceAvailable(1) || this.makeSpace() && this.spaceAvailable(1)) {
            short s2 = this.limit;
            this.limit = (short)(s2 + 1);
            this.bufs[s2] = buf;
        }
        return this;
    }

    public ByteBuffer get(int index) {
        return this.bufs[index];
    }

    public Buffers set(int index, ByteBuffer buf) {
        this.bufs[index] = buf;
        return this;
    }

    public Buffers remove(int index) {
        return this.set(index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readLengthAndData(SocketChannel ch) throws Exception {
        if (this.bufs[0].hasRemaining() && ch.read(this.bufs[0]) < 0) {
            throw new EOFException();
        }
        if (this.bufs[0].hasRemaining()) {
            return null;
        }
        int len = this.bufs[0].getInt(0);
        if (this.max_length > 0 && len > this.max_length) {
            throw new IllegalStateException(String.format("the length of a message (%s) from %s is bigger than the max accepted length (%s): discarding the message", Util.printBytes(len), ch.getRemoteAddress(), Util.printBytes(this.max_length)));
        }
        if (this.bufs[1] == null || len > this.bufs[1].capacity()) {
            this.bufs[1] = ByteBuffer.allocate(len);
        }
        ((Buffer)this.bufs[1]).limit(len);
        if (this.bufs[1].hasRemaining() && ch.read(this.bufs[1]) < 0) {
            throw new EOFException();
        }
        if (this.bufs[1].hasRemaining()) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = (ByteBuffer)((Buffer)this.bufs[1].duplicate()).flip();
            return byteBuffer;
        }
        finally {
            this.bufs[0].clear();
            this.bufs[1].clear();
        }
    }

    public boolean read(SocketChannel ch) throws Exception {
        long bytes = ch.read(this.bufs, this.position, this.limit - this.position);
        if (bytes == -1L) {
            throw new EOFException();
        }
        return this.adjustPosition(false);
    }

    public boolean write(GatheringByteChannel ch, ByteBuffer ... buffers) throws Exception {
        return this.add(buffers).write(ch);
    }

    public boolean write(GatheringByteChannel ch) throws Exception {
        int num_buffers_to_write = this.size();
        if (num_buffers_to_write == 0) {
            return true;
        }
        if (ch != null) {
            try {
                ch.write(this.bufs, this.position, num_buffers_to_write);
            }
            catch (ClosedChannelException closed_ex) {
                throw closed_ex;
            }
            catch (IOException | NotYetConnectedException exception) {
                // empty catch block
            }
        }
        return this.nullData();
    }

    public Buffers copy() {
        for (int i = Math.max(this.position, this.next_to_copy); i < this.limit; ++i) {
            this.bufs[i] = Buffers.copyBuffer(this.bufs[i]);
            this.next_to_copy = (short)(i + 1);
        }
        return this;
    }

    public int size() {
        return this.limit - this.position;
    }

    public String toString() {
        return String.format("[%d bufs pos=%d lim=%d cap=%d rem=%d]", this.size(), this.position, this.limit, this.bufs.length, this.remaining());
    }

    protected boolean spaceAvailable(int num_buffers) {
        return this.bufs.length - this.limit >= num_buffers;
    }

    protected boolean makeSpace() {
        if (this.position == this.limit) {
            this.next_to_copy = 0;
            this.limit = 0;
            this.position = 0;
            return true;
        }
        if (this.position == 0) {
            return false;
        }
        int buffers_to_move = this.size();
        int dest_index = 0;
        int src_index = this.position;
        while (dest_index < buffers_to_move) {
            this.bufs[dest_index] = this.bufs[src_index];
            ++dest_index;
            ++src_index;
        }
        for (int i = buffers_to_move; i < this.limit; ++i) {
            this.bufs[i] = null;
        }
        this.next_to_copy = (short)(this.next_to_copy - this.position);
        this.limit = (short)buffers_to_move;
        this.position = 0;
        this.next_to_copy = (short)Math.max(this.next_to_copy, this.position);
        return true;
    }

    protected boolean nullData() {
        if (!this.adjustPosition(true)) {
            return false;
        }
        if (this.position >= this.bufs.length) {
            this.makeSpace();
        }
        return true;
    }

    protected boolean adjustPosition(boolean null_complete_data) {
        while (this.position < this.limit) {
            ByteBuffer buf = this.bufs[this.position];
            if (buf.remaining() > 0) {
                return false;
            }
            if (null_complete_data) {
                this.bufs[this.position] = null;
            }
            this.position = (short)(this.position + 1);
            if (this.next_to_copy >= this.position) continue;
            this.next_to_copy = this.position;
        }
        return true;
    }

    protected static short toPositiveUnsignedShort(int num) {
        return (short)Buffers.assertPositiveUnsignedShort(num);
    }

    protected static int assertPositiveUnsignedShort(int num) {
        if (num < 1 || num > Short.MAX_VALUE) {
            short tmp = (short)num;
            throw new IllegalArgumentException(String.format("number %d must be a positive unsigned short", tmp));
        }
        return num;
    }

    public static ByteBuffer copyBuffer(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
        int len = buf.remaining();
        byte[] tmp = new byte[len];
        if (!buf.isDirect()) {
            System.arraycopy(buf.array(), offset, tmp, 0, len);
        } else {
            for (int i = 0; i < len; ++i) {
                tmp[i] = buf.get(i + offset);
            }
        }
        return ByteBuffer.wrap(tmp);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new BuffersIterator();
    }

    protected class BuffersIterator
    implements Iterator<ByteBuffer> {
        protected int index = -1;

        protected BuffersIterator() {
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index + 1; i < Buffers.this.bufs.length; ++i) {
                if (Buffers.this.bufs[i] == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public ByteBuffer next() {
            do {
                if (++this.index < Buffers.this.bufs.length) continue;
                throw new NoSuchElementException(String.format("index %d is out of range (%d buffers)", this.index, Buffers.this.bufs.length));
            } while (Buffers.this.bufs[this.index] == null);
            return Buffers.this.bufs[this.index];
        }

        @Override
        public void remove() {
        }
    }
}

