/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.AsciiString;
import org.jgroups.util.NameCache;
import org.jgroups.util.Util;

public class SHARED_LOOPBACK
extends TP {
    protected short port = 1;
    protected PhysicalAddress physical_addr;
    @ManagedAttribute(description="The current view")
    protected volatile View curr_view;
    protected volatile boolean is_server = false;
    protected volatile boolean is_coord = false;
    protected static final Map<AsciiString, Map<Address, SHARED_LOOPBACK>> routing_table = new HashMap<AsciiString, Map<Address, SHARED_LOOPBACK>>();
    protected static final Function<AsciiString, Map<Address, SHARED_LOOPBACK>> FUNC = n -> new HashMap();

    @Override
    public boolean supportsMulticasting() {
        return true;
    }

    public View getView() {
        return this.curr_view;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public boolean isCoord() {
        return this.is_coord;
    }

    public SHARED_LOOPBACK coord(boolean b) {
        this.is_coord = this.is_server = b;
        return this;
    }

    @Override
    public String toString() {
        return "SHARED_LOOPBACK(local address: " + this.local_addr + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Dumps the contents of the routing table")
    public static String dumpRoutingTable() {
        StringBuilder sb = new StringBuilder();
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            for (Map.Entry<AsciiString, Map<Address, SHARED_LOOPBACK>> entry : routing_table.entrySet()) {
                AsciiString cluster_name = entry.getKey();
                Set<Address> mbrs = entry.getValue().keySet();
                sb.append(cluster_name).append(": ").append(mbrs).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToAll(byte[] data2, int offset, int length) throws Exception {
        List<SHARED_LOOPBACK> targets;
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.cluster_name);
            if (dests == null) {
                this.log.trace("no destination found for " + this.cluster_name);
                return;
            }
            targets = dests.entrySet().stream().filter(e -> !Objects.equals(this.local_addr, e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        targets.forEach(target -> {
            try {
                target.receive(this.local_addr, data2, offset, length);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedSendingMessageTo") + target.getAddress(), t);
            }
        });
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data2, int offset, int length) throws Exception {
        this.sendTo(dest, data2, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendTo(Address dest, byte[] buf, int offset, int length) throws Exception {
        SHARED_LOOPBACK target;
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.cluster_name);
            if (dests == null) {
                this.log.trace("no destination found for " + this.cluster_name);
                return;
            }
            target = dests.get(dest);
            if (target == null) {
                this.log.trace("%s: destination address %s not found, routing table:\n%s\n", this.local_addr, dest, SHARED_LOOPBACK.dumpRoutingTable());
                return;
            }
        }
        target.receive(this.local_addr, buf, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PingData> getDiscoveryResponsesFor(String cluster_name) {
        if (cluster_name == null) {
            return null;
        }
        ArrayList<PingData> rsps = new ArrayList<PingData>();
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            Map<Address, SHARED_LOOPBACK> mbrs = routing_table.get(new AsciiString(cluster_name));
            if (mbrs != null) {
                for (Map.Entry<Address, SHARED_LOOPBACK> entry : mbrs.entrySet()) {
                    Address addr = entry.getKey();
                    SHARED_LOOPBACK l = entry.getValue();
                    PingData data2 = new PingData(addr, l.isServer(), NameCache.get(addr), null).coord(l.isCoord());
                    rsps.add(data2);
                }
            }
        }
        return rsps;
    }

    @Override
    public String getInfo() {
        return this.toString();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                SHARED_LOOPBACK.register(this.cluster_name, this.local_addr, this);
                break;
            }
            case 4: {
                SHARED_LOOPBACK.unregister(this.cluster_name, this.local_addr);
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 109: {
                return SHARED_LOOPBACK.getDiscoveryResponsesFor((String)evt.getArg());
            }
            case 87: {
                if (this.cluster_name == null) {
                    return retval;
                }
                Address mbr = (Address)evt.getArg();
                Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
                synchronized (map) {
                    Map<Address, SHARED_LOOPBACK> map2 = routing_table.get(this.cluster_name);
                    SHARED_LOOPBACK lp = map2 != null ? map2.get(mbr) : null;
                    return lp != null ? lp.getPhysicalAddress() : null;
                }
            }
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        short s2 = this.port;
        this.port = (short)(s2 + 1);
        this.physical_addr = new IpAddress(InetAddress.getLoopbackAddress(), (int)s2);
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        this.is_server = false;
        SHARED_LOOPBACK.unregister(this.cluster_name, this.local_addr);
    }

    @Override
    public void destroy() {
        super.destroy();
        SHARED_LOOPBACK.unregister(this.cluster_name, this.local_addr);
    }

    protected void handleViewChange(View v) {
        this.curr_view = v;
        this.is_coord = Objects.equals(this.local_addr, v.getCoord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void register(AsciiString cluster, Address local_addr, SHARED_LOOPBACK shared_loopback) {
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            Map<Address, SHARED_LOOPBACK> map2 = routing_table.computeIfAbsent(cluster, FUNC);
            if (map2.isEmpty()) {
                shared_loopback.coord(true);
            }
            map2.putIfAbsent(local_addr, shared_loopback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregister(AsciiString cluster, Address local_addr) {
        Map<AsciiString, Map<Address, SHARED_LOOPBACK>> map = routing_table;
        synchronized (map) {
            Map<Address, SHARED_LOOPBACK> map2;
            Map<Address, SHARED_LOOPBACK> map3 = map2 = cluster != null ? routing_table.get(cluster) : null;
            if (map2 != null && map2.remove(local_addr) != null && map2.isEmpty()) {
                routing_table.remove(cluster);
            }
        }
    }
}

