/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.MsgStats;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Protocol which exposes various statistics such as sent messages, number of bytes received etc")
public class STATS
extends Protocol {
    protected static final short UP = 1;
    protected static final short DOWN = 2;
    protected static final Address NULL_DEST = Global.NULL_ADDRESS;
    @Component
    protected final MsgStats mstats = new MsgStats();
    protected final ConcurrentMap<Address, MsgStats> sent = new ConcurrentHashMap<Address, MsgStats>();
    protected final ConcurrentMap<Address, MsgStats> received = new ConcurrentHashMap<Address, MsgStats>();

    @Override
    public void resetStats() {
        this.mstats.reset();
        this.sent.clear();
        this.received.clear();
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        this.updateStats(msg.dest(), msg.src(), 1, msg.getLength(), (short)1);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        this.updateStats(batch.dest(), batch.sender(), batch.size(), batch.length(), (short)1);
        this.up_prot.up(batch);
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        this.updateStats(msg.dest(), msg.src(), 1, msg.getLength(), (short)2);
        return this.down_prot.down(msg);
    }

    @ManagedOperation
    public String printStats() {
        Object val;
        Object key;
        StringBuilder sb = new StringBuilder();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key = entry.getKey();
            if (key == NULL_DEST) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        return sb.toString();
    }

    private void handleViewChange(View view) {
        List<Address> members2 = view.getMembers();
        LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(members2);
        tmp.add(null);
        this.sent.keySet().retainAll(tmp);
        this.received.keySet().retainAll(tmp);
    }

    protected void updateStats(Address dest, Address src, int num_msgs, int num_bytes, short direction) {
        Address key;
        boolean mcast2;
        boolean bl = mcast2 = dest == null;
        if (direction == 1) {
            this.mstats.incrNumMsgsReceived(num_msgs);
            this.mstats.incrNumBytesReceived(num_bytes);
            if (mcast2) {
                this.mstats.incrNumMcastMsgsReceived(num_msgs);
                this.mstats.incrNumMcastBytesReceived(num_bytes);
            } else {
                this.mstats.incrNumUcastMsgsReceived(num_msgs);
                this.mstats.incrNumUcastBytesReceived(num_bytes);
            }
        } else {
            this.mstats.incrNumMsgsSent(num_msgs);
            this.mstats.incrNumBytesSent(num_bytes);
            if (mcast2) {
                this.mstats.incrNumMcastMsgsSent(num_msgs);
                this.mstats.incrNumMcastBytesSent(num_bytes);
            } else {
                this.mstats.incrNumUcastMsgsSent(num_msgs);
                this.mstats.incrNumUcastBytesSent(num_bytes);
            }
        }
        Address address = key = direction == 1 ? src : dest;
        if (key == null) {
            key = NULL_DEST;
        }
        ConcurrentMap<Address, MsgStats> map = direction == 1 ? this.received : this.sent;
        MsgStats entry = map.computeIfAbsent(key, k -> new MsgStats());
        if (direction == 1) {
            entry.incrNumMsgsSent(num_msgs);
            entry.incrNumBytesSent(num_bytes);
            if (mcast2) {
                entry.incrNumMcastMsgsSent(num_msgs);
                entry.incrNumMcastBytesSent(num_bytes);
            } else {
                entry.incrNumUcastMsgsSent(num_msgs);
                entry.incrNumUcastBytesSent(num_bytes);
            }
        } else {
            entry.incrNumMsgsReceived(num_msgs);
            entry.incrNumBytesReceived(num_bytes);
            if (mcast2) {
                entry.incrNumMcastMsgsReceived(num_msgs);
                entry.incrNumMcastBytesReceived(num_bytes);
            } else {
                entry.incrNumUcastMsgsReceived(num_msgs);
                entry.incrNumUcastBytesReceived(num_bytes);
            }
        }
    }
}

