/*
 * Decompiled with CFR 0.152.
 */
package org.jline.console.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jline.builtins.Nano;
import org.jline.builtins.Styles;
import org.jline.console.SystemRegistry;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class SystemHighlighter
extends DefaultHighlighter {
    private static final StyleResolver resolver = Styles.lsStyle();
    protected final Nano.SyntaxHighlighter commandHighlighter;
    protected final Nano.SyntaxHighlighter argsHighlighter;
    protected final Nano.SyntaxHighlighter langHighlighter;
    protected final SystemRegistry systemRegistry;
    protected final Map<String, FileHighlightCommand> fileHighlight = new HashMap<String, FileHighlightCommand>();

    public SystemHighlighter(Nano.SyntaxHighlighter commandHighlighter, Nano.SyntaxHighlighter argsHighlighter, Nano.SyntaxHighlighter langHighlighter) {
        this.commandHighlighter = commandHighlighter;
        this.argsHighlighter = argsHighlighter;
        this.langHighlighter = langHighlighter;
        this.systemRegistry = SystemRegistry.get();
    }

    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        return this.doDefaultHighlight(reader) ? super.highlight(reader, buffer) : this.systemHighlight(reader, buffer);
    }

    public void addFileHighlight(String ... commands) {
        for (String c : commands) {
            this.fileHighlight.put(c, new FileHighlightCommand());
        }
    }

    public void addFileHighlight(String command, String subcommand, Collection<String> fileOptions) {
        this.fileHighlight.put(command, new FileHighlightCommand(subcommand, fileOptions));
    }

    private boolean doDefaultHighlight(LineReader reader) {
        String search = reader.getSearchTerm();
        return search != null && search.length() > 0 || reader.getRegionActive() != LineReader.RegionType.NONE || this.errorIndex > -1 || this.errorPattern != null;
    }

    protected AttributedString systemHighlight(LineReader reader, String buffer) {
        FileHighlightCommand fhc;
        Parser parser = reader.getParser();
        String command = parser.getCommand(buffer);
        AttributedString out = buffer.trim().isEmpty() ? new AttributedStringBuilder().append(buffer).toAttributedString() : (this.fileHighlight.containsKey(command) ? (!(fhc = this.fileHighlight.get(command)).hasFileOptions() ? this.doFileArgsHighlight(reader, buffer, fhc) : this.doFileOptsHighlight(reader, buffer, fhc)) : (this.systemRegistry.isCommandOrScript(command) || this.systemRegistry.isCommandAlias(command) ? this.doCommandHighlight(buffer) : (this.langHighlighter != null ? this.langHighlighter.highlight(buffer) : new AttributedStringBuilder().append(buffer).toAttributedString())));
        return out;
    }

    protected AttributedString doFileOptsHighlight(LineReader reader, String buffer, FileHighlightCommand fhc) {
        int idx0 = this.commandIndex(buffer);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        if (idx0 < 0) {
            this.highlightCommand(buffer, asb);
        } else {
            this.highlightCommand(buffer.substring(0, idx0), asb);
            ParsedLine parsedLine = reader.getParser().parse(buffer, buffer.length() + 1, Parser.ParseContext.COMPLETE);
            List<String> words = parsedLine.words();
            if (!fhc.isSubcommand() || words.size() > 2 && fhc.getSubcommand().equals(words.get(1))) {
                int firstArg = fhc.isSubcommand() ? 1 : 0;
                int idx = buffer.indexOf(words.get(firstArg)) + words.get(firstArg).length() + 1;
                this.highlightArgs(buffer.substring(idx0, idx), asb);
                boolean fileOption = false;
                for (int i = firstArg + 1; i < words.size(); ++i) {
                    int nextIdx = buffer.substring(idx).indexOf(words.get(i)) + idx;
                    for (int j = idx; j < nextIdx; ++j) {
                        asb.append(buffer.charAt(j));
                    }
                    String word = words.get(i);
                    if (word.contains("=") && fhc.getFileOptions().contains(word.substring(0, word.indexOf("=")))) {
                        this.highlightArgs(word.substring(0, word.indexOf("=") + 1), asb);
                        this.highlightFileArg(reader, word.substring(word.indexOf("=") + 1), asb);
                    } else if (fhc.getFileOptions().contains(word)) {
                        this.highlightArgs(word, asb);
                        fileOption = true;
                    } else if (fileOption) {
                        this.highlightFileArg(reader, word, asb);
                    } else {
                        this.highlightArgs(word, asb);
                        fileOption = false;
                    }
                    idx = nextIdx + word.length();
                }
            } else {
                this.highlightArgs(buffer.substring(idx0), asb);
            }
        }
        return asb.toAttributedString();
    }

    protected AttributedString doFileArgsHighlight(LineReader reader, String buffer, FileHighlightCommand fhc) {
        int idx0 = this.commandIndex(buffer);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        if (idx0 < 0) {
            this.highlightCommand(buffer, asb);
        } else {
            this.highlightCommand(buffer.substring(0, idx0), asb);
            ParsedLine parsedLine = reader.getParser().parse(buffer, buffer.length() + 1, Parser.ParseContext.COMPLETE);
            List<String> words = parsedLine.words();
            if (!fhc.isSubcommand() || words.size() > 2 && fhc.getSubcommand().equals(words.get(1))) {
                int firstArg = fhc.isSubcommand() ? 1 : 0;
                int idx = buffer.indexOf(words.get(firstArg)) + words.get(firstArg).length();
                this.highlightArgs(buffer.substring(idx0, idx), asb);
                for (int i = firstArg + 1; i < words.size(); ++i) {
                    int nextIdx = buffer.substring(idx).indexOf(words.get(i)) + idx;
                    for (int j = idx; j < nextIdx; ++j) {
                        asb.append(buffer.charAt(j));
                    }
                    this.highlightFileArg(reader, words.get(i), asb);
                    idx = nextIdx + words.get(i).length();
                }
            } else {
                this.highlightArgs(buffer.substring(idx0), asb);
            }
        }
        return asb.toAttributedString();
    }

    protected AttributedString doCommandHighlight(String buffer) {
        AttributedString out;
        if (this.commandHighlighter != null || this.argsHighlighter != null) {
            int idx = this.commandIndex(buffer);
            AttributedStringBuilder asb = new AttributedStringBuilder();
            if (idx < 0) {
                this.highlightCommand(buffer, asb);
            } else {
                this.highlightCommand(buffer.substring(0, idx), asb);
                this.highlightArgs(buffer.substring(idx), asb);
            }
            out = asb.toAttributedString();
        } else {
            out = new AttributedStringBuilder().append(buffer).toAttributedString();
        }
        return out;
    }

    private int commandIndex(String buffer) {
        int idx = -1;
        boolean cmdFound = false;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c != ' ') {
                cmdFound = true;
                continue;
            }
            if (!cmdFound) continue;
            idx = i;
            break;
        }
        return idx;
    }

    private void highlightFileArg(LineReader reader, String arg, AttributedStringBuilder asb) {
        if (arg.startsWith("-")) {
            this.highlightArgs(arg, asb);
        } else {
            String separator = reader.isSet(LineReader.Option.USE_FORWARD_SLASH) ? "/" : Paths.get(System.getProperty("user.dir"), new String[0]).getFileSystem().getSeparator();
            StringBuilder sb = new StringBuilder();
            try {
                Path path = new File(arg).toPath();
                Iterator<Path> iterator2 = path.iterator();
                if (OSUtils.IS_WINDOWS && arg.matches("^[A-Za-z]:.*$")) {
                    if (arg.length() == 2) {
                        sb.append(arg);
                        asb.append(arg);
                    } else if (arg.charAt(2) == separator.charAt(0)) {
                        sb.append(arg.substring(0, 3));
                        asb.append(arg.substring(0, 3));
                    }
                }
                if (arg.startsWith(separator)) {
                    sb.append(separator);
                    asb.append(separator);
                }
                while (iterator2.hasNext()) {
                    sb.append(iterator2.next());
                    this.highlightFile(new File(sb.toString()).toPath(), asb);
                    if (!iterator2.hasNext()) continue;
                    sb.append(separator);
                    asb.append(separator);
                }
                if (arg.length() > 2 && !arg.matches("^[A-Za-z]:" + separator) && arg.endsWith(separator)) {
                    asb.append(separator);
                }
            }
            catch (Exception e) {
                asb.append(arg);
            }
        }
    }

    private void highlightFile(Path path, AttributedStringBuilder asb) {
        String type2;
        AttributedStringBuilder sb = new AttributedStringBuilder();
        String name = path.getFileName().toString();
        int idx = name.lastIndexOf(".");
        String string2 = type2 = idx != -1 ? ".*" + name.substring(idx) : null;
        if (Files.isSymbolicLink(path)) {
            sb.styled(resolver.resolve(".ln"), (CharSequence)name);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            sb.styled(resolver.resolve(".di"), (CharSequence)name);
        } else if (Files.isExecutable(path) && !OSUtils.IS_WINDOWS) {
            sb.styled(resolver.resolve(".ex"), (CharSequence)name);
        } else if (type2 != null && resolver.resolve(type2).getStyle() != 0L) {
            sb.styled(resolver.resolve(type2), (CharSequence)name);
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            sb.styled(resolver.resolve(".fi"), (CharSequence)name);
        } else {
            sb.append(name);
        }
        asb.append(sb);
    }

    private void highlightArgs(String args2, AttributedStringBuilder asb) {
        if (this.argsHighlighter != null) {
            asb.append(this.argsHighlighter.highlight(args2));
        } else {
            asb.append(args2);
        }
    }

    private void highlightCommand(String command, AttributedStringBuilder asb) {
        if (this.commandHighlighter != null) {
            asb.append(this.commandHighlighter.highlight(command));
        } else {
            asb.append(command);
        }
    }

    protected static class FileHighlightCommand {
        private final String subcommand;
        private final List<String> fileOptions = new ArrayList<String>();

        public FileHighlightCommand() {
            this(null, new ArrayList<String>());
        }

        public FileHighlightCommand(String subcommand, Collection<String> fileOptions) {
            this.subcommand = subcommand;
            this.fileOptions.addAll(fileOptions);
        }

        public boolean isSubcommand() {
            return this.subcommand != null;
        }

        public boolean hasFileOptions() {
            return !this.fileOptions.isEmpty();
        }

        public String getSubcommand() {
            return this.subcommand;
        }

        public List<String> getFileOptions() {
            return this.fileOptions;
        }
    }
}

