/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceComponentPlugin;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.internal.SubstancePluginRepository;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopupFactory;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public abstract class SubstanceLookAndFeel
extends BasicLookAndFeel {
    private PropertyChangeListener focusOwnerChangeListener;
    private KeyboardFocusManager currentKeyboardFocusManager;
    protected SubstanceSkin skin;
    protected String name;

    protected SubstanceLookAndFeel(SubstanceSkin skin) {
        this.skin = skin;
        this.name = "Substance " + skin.getDisplayName();
    }

    @Override
    public String getDescription() {
        return "Substance Look and Feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String UI_CLASSNAME_PREFIX = "org.pushingpixels.substance.internal.ui.Substance";
        Object[] uiDefaults = new Object[]{"ButtonUI", UI_CLASSNAME_PREFIX + "ButtonUI", "CheckBoxUI", UI_CLASSNAME_PREFIX + "CheckBoxUI", "ComboBoxUI", UI_CLASSNAME_PREFIX + "ComboBoxUI", "CheckBoxMenuItemUI", UI_CLASSNAME_PREFIX + "CheckBoxMenuItemUI", "DesktopIconUI", UI_CLASSNAME_PREFIX + "DesktopIconUI", "DesktopPaneUI", UI_CLASSNAME_PREFIX + "DesktopPaneUI", "EditorPaneUI", UI_CLASSNAME_PREFIX + "EditorPaneUI", "FileChooserUI", UI_CLASSNAME_PREFIX + "FileChooserUI", "FormattedTextFieldUI", UI_CLASSNAME_PREFIX + "FormattedTextFieldUI", "InternalFrameUI", UI_CLASSNAME_PREFIX + "InternalFrameUI", "LabelUI", UI_CLASSNAME_PREFIX + "LabelUI", "ListUI", UI_CLASSNAME_PREFIX + "ListUI", "MenuUI", UI_CLASSNAME_PREFIX + "MenuUI", "MenuBarUI", UI_CLASSNAME_PREFIX + "MenuBarUI", "MenuItemUI", UI_CLASSNAME_PREFIX + "MenuItemUI", "OptionPaneUI", UI_CLASSNAME_PREFIX + "OptionPaneUI", "PanelUI", UI_CLASSNAME_PREFIX + "PanelUI", "PasswordFieldUI", UI_CLASSNAME_PREFIX + "PasswordFieldUI", "PopupMenuUI", UI_CLASSNAME_PREFIX + "PopupMenuUI", "PopupMenuSeparatorUI", UI_CLASSNAME_PREFIX + "PopupMenuSeparatorUI", "ProgressBarUI", UI_CLASSNAME_PREFIX + "ProgressBarUI", "RadioButtonUI", UI_CLASSNAME_PREFIX + "RadioButtonUI", "RadioButtonMenuItemUI", UI_CLASSNAME_PREFIX + "RadioButtonMenuItemUI", "RootPaneUI", UI_CLASSNAME_PREFIX + "RootPaneUI", "ScrollBarUI", UI_CLASSNAME_PREFIX + "ScrollBarUI", "ScrollPaneUI", UI_CLASSNAME_PREFIX + "ScrollPaneUI", "SeparatorUI", UI_CLASSNAME_PREFIX + "SeparatorUI", "SliderUI", UI_CLASSNAME_PREFIX + "SliderUI", "SpinnerUI", UI_CLASSNAME_PREFIX + "SpinnerUI", "SplitPaneUI", UI_CLASSNAME_PREFIX + "SplitPaneUI", "TabbedPaneUI", UI_CLASSNAME_PREFIX + "TabbedPaneUI", "TableUI", UI_CLASSNAME_PREFIX + "TableUI", "TableHeaderUI", UI_CLASSNAME_PREFIX + "TableHeaderUI", "TextAreaUI", UI_CLASSNAME_PREFIX + "TextAreaUI", "TextFieldUI", UI_CLASSNAME_PREFIX + "TextFieldUI", "TextPaneUI", UI_CLASSNAME_PREFIX + "TextPaneUI", "ToggleButtonUI", UI_CLASSNAME_PREFIX + "ToggleButtonUI", "ToolBarUI", UI_CLASSNAME_PREFIX + "ToolBarUI", "ToolBarSeparatorUI", UI_CLASSNAME_PREFIX + "ToolBarSeparatorUI", "ToolTipUI", UI_CLASSNAME_PREFIX + "ToolTipUI", "TreeUI", UI_CLASSNAME_PREFIX + "TreeUI", "ViewportUI", UI_CLASSNAME_PREFIX + "ViewportUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        SubstanceCortex.GlobalScope.initFontDefaults(table);
        this.skin.addCustomEntriesToTable(table);
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        SubstancePluginRepository.getInstance().processAllDefaultsEntriesComponentPlugins(table, this.skin);
        return table;
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
        SubstanceCortex.GlobalScope.setSkin(this.skin, false);
        String traceFilename = (String)UIManager.get("substancelaf.internal.traceFile");
        if (traceFilename != null) {
            MemoryAnalyzer.commence(1000L, traceFilename);
            for (SubstanceComponentPlugin plugin : SubstancePluginRepository.getInstance().getComponentPlugins()) {
                MemoryAnalyzer.enqueueUsage("Has plugin '" + plugin.getClass().getName() + "'");
            }
        }
        String heapStatusTraceFilename = (String)UIManager.get("substancelaf.internal.heapStatusTraceFile");
        SubstanceTitlePane.setHeapStatusLogfileName(heapStatusTraceFilename);
        SubstancePluginRepository.getInstance().initializeAllComponentPlugins();
        this.focusOwnerChangeListener = evt -> {
            Component newFocusOwner;
            if ("focusOwner".equals(evt.getPropertyName()) && (newFocusOwner = (Component)evt.getNewValue()) != null) {
                JRootPane rootPane = SwingUtilities.getRootPane(newFocusOwner);
                if (rootPane == null) {
                    return;
                }
                JButton defaultButton = rootPane.getDefaultButton();
                if (defaultButton == null) {
                    return;
                }
                defaultButton.repaint();
            }
            if ("managingFocus".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                this.currentKeyboardFocusManager.removePropertyChangeListener(this.focusOwnerChangeListener);
                this.currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.currentKeyboardFocusManager.addPropertyChangeListener(this.focusOwnerChangeListener);
            }
        };
        this.currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.currentKeyboardFocusManager.addPropertyChangeListener(this.focusOwnerChangeListener);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        SubstanceCortex.GlobalScope.unsetSkin();
        ShadowPopupFactory.uninstall();
        SubstanceCoreUtilities.stopThreads();
        if (this.skin.getWatermark() != null) {
            this.skin.getWatermark().dispose();
        }
        SubstancePluginRepository.getInstance().uninitializeAllComponentPlugins();
        LazyResettableHashMap.reset();
        this.currentKeyboardFocusManager.removePropertyChangeListener(this.focusOwnerChangeListener);
        this.focusOwnerChangeListener = null;
        this.currentKeyboardFocusManager = null;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon == null) {
            return null;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.DISABLED_UNSELECTED);
        BufferedImage result2 = SubstanceImageCreator.getColorSchemeImage(component, icon, colorScheme, 0.5f);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(component, ComponentState.DISABLED_UNSELECTED);
        if (alpha < 1.0f) {
            BufferedImage intermediate = SubstanceCoreUtilities.getBlankUnscaledImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D g2d = intermediate.createGraphics();
            g2d.setComposite(AlphaComposite.SrcOver.derive(alpha));
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(result2, 0, 0, result2.getWidth(), result2.getHeight(), null);
            g2d.dispose();
            result2 = intermediate;
        }
        return new SubstanceIconUIResource(result2);
    }
}

