/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public class StandardButtonShaper
implements SubstanceButtonShaper,
RectangularButtonShaper {
    private static final LazyResettableHashMap<GeneralPath> contours = new LazyResettableHashMap("StandardButtonShaper");

    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton button, float extraInsets, float width, float height, boolean isInner2) {
        HashMapKey key;
        GeneralPath result2;
        Set<SubstanceSlices.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonStraightSide");
        float radius = this.getCornerRadius(button, extraInsets);
        if (isInner2 && (radius -= SubstanceSizeUtils.getBorderStrokeWidth()) < 0.0f) {
            radius = 0.0f;
        }
        if ((result2 = contours.get(key = SubstanceCoreUtilities.getHashKey(Float.valueOf(width), Float.valueOf(height), straightSides, Float.valueOf(radius), Float.valueOf(extraInsets)))) != null) {
            return result2;
        }
        result2 = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, extraInsets);
        contours.put(key, result2);
        return result2;
    }

    @Override
    public Border getButtonBorder(final AbstractButton button) {
        return new SubstanceButtonBorder(StandardButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
                Insets buttonInsets = SubstanceSizeUtils.getButtonInsets(fontSize);
                float focusPadding = SubstanceSizeUtils.getFocusRingPadding(fontSize);
                int lrPadding = SubstanceCoreUtilities.hasText(button) ? SubstanceSizeUtils.getTextButtonLRPadding(fontSize) : 0;
                Set<SubstanceSlices.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonOpenSide");
                int left = lrPadding + buttonInsets.left + (int)focusPadding + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.LEFT) ? -1 : 0);
                int right = lrPadding + buttonInsets.right + (int)focusPadding + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.RIGHT) ? -1 : 0);
                int top = buttonInsets.top + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.TOP) ? -1 : 0);
                int bottom = buttonInsets.bottom + (openSides != null && openSides.contains((Object)SubstanceSlices.Side.BOTTOM) ? -1 : 0);
                return new Insets(top, left, bottom, right);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result2 = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth + uiPreferredSize.height, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result2 = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result2.height;
            result2 = new Dimension(result2.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result2 = new Dimension(result2.width + margin.left + margin.right, result2.height + margin.top + margin.bottom);
        }
        int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result2.getHeight() - (double)iconPaddingHeight) {
                result2 = new Dimension(result2.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result2.getWidth() - (double)iconPaddingWidth) {
                result2 = new Dimension(iconWidth, result2.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result2 = new Dimension(result2.width + iconPaddingWidth, result2.height);
        }
        if (toTweakHeight) {
            result2 = new Dimension(result2.width, result2.height + iconPaddingHeight);
        }
        if (result2.height % 2 != 0) {
            ++result2.height;
        }
        return result2;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, float insets) {
        Border parentBorder;
        float width = (float)button.getWidth() - 2.0f * insets;
        float height = (float)button.getHeight() - 2.0f * insets;
        boolean isRoundCorners = StandardButtonShaper.isRoundButton(button);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (button != null && button.getClass().isAnnotationPresent(SubstanceInternalArrowButton.class) && (parentBorder = ((JComponent)button.getParent()).getBorder()) instanceof SubstanceBorder) {
            radius *= ((SubstanceBorder)parentBorder).getRadiusScaleFactor();
        }
        if (isRoundCorners) {
            radius = width > height ? height / 2.0f : width / 2.0f;
        }
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

