/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.intellij;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.pushingpixels.substance.internal.contrib.intellij.GraphicsConfig;

public class GraphicsUtil {
    private static final Graphics2D ourGraphics = new BufferedImage(1, 1, 2).createGraphics();

    public static void setupFractionalMetrics(Graphics g2) {
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void setupAntialiasing(Graphics g2) {
        GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static int stringWidth(String text, Font font) {
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
        return ourGraphics.getFontMetrics(font).stringWidth(text);
    }

    public static int charsWidth(char[] data2, int off, int len, Font font) {
        return ourGraphics.getFontMetrics(font).charsWidth(data2, off, len);
    }

    public static int charWidth(char ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static int charWidth(int ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static void setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        if (g2 instanceof Graphics2D) {
            Graphics2D g3 = (Graphics2D)g2;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null && !ignoreSystemSettings) {
                g3.addRenderingHints(map);
            } else {
                g3.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, enableAA ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public static GraphicsConfig setupAAPainting(Graphics g2) {
        GraphicsConfig config = new GraphicsConfig(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return config;
    }

    public static GraphicsConfig disableAAPainting(Graphics g2) {
        GraphicsConfig config = new GraphicsConfig(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g22.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        return config;
    }

    public static GraphicsConfig paintWithAlpha(Graphics g2, float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsConfig config = new GraphicsConfig(g2);
        Graphics2D g22 = (Graphics2D)g2;
        g22.setComposite(AlphaComposite.getInstance(3, alpha));
        return config;
    }

    static {
        GraphicsUtil.setupFractionalMetrics(ourGraphics);
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
    }
}

