/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.reflections8.Configuration;
import org.reflections8.ReflectionsException;
import org.reflections8.util.SetMultimap;
import org.reflections8.util.SynchronizedHashSetMultimap;

public class Store {
    private transient boolean concurrent;
    private final Map<String, SetMultimap<String, String>> storeMap = new HashMap<String, SetMultimap<String, String>>();

    protected Store() {
        this.concurrent = false;
    }

    public Store(Configuration configuration) {
        this.concurrent = configuration.getExecutorService().isPresent();
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    public SetMultimap<String, String> getOrCreate(String index) {
        SynchronizedHashSetMultimap mmap = this.storeMap.get(index);
        if (mmap == null) {
            SynchronizedHashSetMultimap multimap = new SynchronizedHashSetMultimap(new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Collections.newSetFromMap(new ConcurrentHashMap());
                }
            });
            mmap = this.concurrent ? new SynchronizedHashSetMultimap(multimap) : multimap;
            this.storeMap.put(index, mmap);
        }
        return mmap;
    }

    public SetMultimap<String, String> get(String index) {
        SetMultimap<String, String> mmap = this.storeMap.get(index);
        if (mmap == null) {
            throw new ReflectionsException("Scanner " + index + " was not configured");
        }
        return mmap;
    }

    public Iterable<String> get(String index, String ... keys2) {
        return this.get(index, Arrays.asList(keys2));
    }

    public Iterable<String> get(String index, Iterable<String> keys2) {
        SetMultimap<String, String> mmap = this.get(index);
        IterableChain<String> result2 = new IterableChain<String>();
        for (String key : keys2) {
            ((IterableChain)result2).addAll((Iterable)mmap.get(key));
        }
        return result2;
    }

    private Iterable<String> getAllIncluding(String index, Iterable<String> keys2, IterableChain<String> result2) {
        ((IterableChain)result2).addAll(keys2);
        for (String key : keys2) {
            Iterable<String> values2 = this.get(index, key);
            if (!values2.iterator().hasNext()) continue;
            this.getAllIncluding(index, values2, result2);
        }
        return result2;
    }

    public Iterable<String> getAll(String index, String key) {
        return this.getAllIncluding(index, this.get(index, key), new IterableChain<String>());
    }

    public Iterable<String> getAll(String index, Iterable<String> keys2) {
        return this.getAllIncluding(index, this.get(index, keys2), new IterableChain<String>());
    }

    private static class IterableChain<T>
    implements Iterable<T> {
        private final List<Iterable<T>> chain = new ArrayList<Iterable<T>>();

        private IterableChain() {
        }

        private void addAll(Iterable<T> iterable) {
            this.chain.add(iterable);
        }

        @Override
        public Iterator<T> iterator() {
            ArrayList result2 = new ArrayList();
            this.chain.forEach(iterable -> {
                if (iterable != null) {
                    iterable.forEach(element -> result2.add(element));
                }
            });
            return result2.iterator();
        }
    }
}

